import { keccak256, toBytes, hexToBytes, toHex, getAddress } from "viem";

/**
 * Derive a deterministic pseudo EVM address from a stable string.
 * This address is not backed by a private key and is meant only as an on-chain label.
 */
export function derivePseudoAddress(stableId: string): `0x${string}` {
  // Hash a namespaced value (avoid collisions)
  const bytes = toBytes(`hospital-tickets:${stableId}`);
  const digest = keccak256(bytes); // 32 bytes hex
  // take the last 20 bytes as address
  const addrBytes = hexToBytes(digest).slice(-20);
  const addrHex = toHex(addrBytes); // 0x + 40 hex chars
  // checksum to EIP-55
  return getAddress(addrHex);
}
